% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cran_help.R
\name{cran_help_pages_not_linked}
\alias{cran_help_pages_not_linked}
\title{Help pages without links}
\usage{
cran_help_pages_not_linked(packages = NULL)
}
\arguments{
\item{packages}{A vector with packages or \code{NULL} for all packages.}
}
\value{
A data.frame with two columns: Package and Source
\code{NA} if not able to collect the data from CRAN.
}
\description{
Help pages without links to other help pages.
This makes harder to navigate to related help pages.
}
\examples{
\donttest{
ap <- available.packages()
if (NROW(ap)) {
    a_package <- rownames(ap)[startsWith(rownames(ap), "A")][1]
    chnl <- cran_help_pages_not_linked(a_package)
    head(chnl)
}
}
}
\seealso{
Other functions related to CRAN help pages: 
\code{\link{cran_help_cliques}()},
\code{\link{cran_help_pages_wo_links}()}
}
\concept{functions related to CRAN help pages}
