% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_inspect_pairs.R
\name{get_inspect_pairs}
\alias{get_inspect_pairs}
\title{Get a subset of pairs to inspect}
\usage{
get_inspect_pairs(
  pairs,
  variable,
  threshold,
  position = NULL,
  n = 11,
  x = attr(pairs, "x"),
  y = attr(pairs, "y")
)
}
\arguments{
\item{pairs}{\code{\link{data.table}} with pairs.}

\item{variable}{name of variable to base the selection on; should be a variable
with the similarity score of the pairs.}

\item{threshold}{the threshold around which to select pairs. Used when position 
is not given.}

\item{position}{select pairs around this position (based on order of 
\code{variable}), e.g. \code{position = 1} will select the pairs with the 
highest similarity score.}

\item{n}{number of pairs to select. Pairs are selected symmetric around the 
theshold.}

\item{x}{\code{data.table} with one half of the pairs.}

\item{y}{\code{data.table} with the other half of the pairs.}
}
\value{
Returns a list with elements \code{pairs} with the selected pairs; 
\code{x} records from \code{x} corresponding to the pairs; \code{y} records
from \code{y} corresponding to the pairs; \code{position} position of the 
selected pairs; \code{index} index of the pairs in \code{pairs}.
}
\description{
Get a subset of pairs to inspect
}
