% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DIC.R
\name{DIC}
\alias{DIC}
\alias{DIC.libbi}
\title{Compute Deviance Information Criterion (DIC) for a libbi model}
\usage{
\method{DIC}{libbi}(x, bootstrap = 0, ...)
}
\arguments{
\item{x}{a \code{libbi} object}

\item{bootstrap}{number of bootstrap samples to take, 0 to just take data}

\item{...}{any parameters to be passed to `bi_read` (e.g., `burn`)}
}
\value{
DIC
}
\description{
Computes the DIC of a libbi object containing Monte-Carlo samples. The
  effective number of parameters is calculated following Gelman et al.,
  Bayesian Data Analysis: Second Edition, 2004, p. 182.
}
\examples{
example_run <- rbi::bi_read(
  system.file(package = "rbi", "example_output.nc")
)
example_model_file <- system.file(package = "rbi", "PZ.bi")
example_bi <- rbi::attach_data(
  rbi::libbi(example_model_file), "output", example_run
)
DIC(example_bi)
}
\author{
Sebastian Funk
}
