% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{pomp}
\alias{pomp}
\title{Recode a Numeric Vector to Percentage of Maximum Possible (POMP) Units}
\usage{
pomp(x, mini, maxi, relative = FALSE, unit = 1)
}
\arguments{
\item{x}{numeric vector.}

\item{mini}{numeric vector of length 1 specifying the minimum numeric value
possible.}

\item{maxi}{numeric vector of length 1 specifying the maximum numeric value
possible.}

\item{relative}{logical vector of length 1 specifying whether relative POMP
scores (rather than absolute POMP scores) should be created. If TRUE, then
the \code{mini} and \code{maxi} arguments are ignored. See details for the
distinction between absolute and relative POMP scores.}

\item{unit}{numeric vector of length 1 specifying how many percentage points
is desired for the units. Traditionally, POMP scores use \code{unit} = 1
(default) such that one unit is one percentage point. However, another
option is to use \code{unit} = 100 such that one unit is all 100 percentage
points (i.e., proportion of maximum possible). This argument also gives the
flexibility of specifying units in between 1 and 100 percentage points. For
example, \code{unit} = 50 would mean that one unit represents going from
low (i.e., 25th percentile) to high (i.e., 75th percentile) on the
variable.}
}
\value{
numeric vector from recoding \code{x} to percentage of maximum
  possible (pomp) with units specified by \code{unit}.
}
\description{
\code{pomp} recodes a numeric vector to percentage of maximum possible (POMP)
units. This can be useful when data is measured with arbitrary units (e.g.,
Likert scale).
}
\details{
There are too common approaches to POMP scores: 1) absolute POMP units where
the minimum and maximum are the smallest/largest values possible from the
measurement instrument (e.g., 1 to 7 on a Likert scale) and 2) relative POMP
units where the minimum and maximum are the smallest/largest values observed
in the data (e.g., 1.3 to 6.8 on a Likert scale). Both will be correlated
perfectly with the original units as they are each linear transformations.
}
\examples{
vec <- psych::bfi[[1]]
pomp(x = vec, mini = 1, maxi = 6) # absolute POMP units
pomp(x = vec, relative = TRUE) # relative POMP units
pomp(x = vec, mini = 1, maxi = 6, unit = 100) # unit = 100
pomp(x = vec, mini = 1, maxi = 6, unit = 50) # unit = 50
}
\seealso{
\code{\link{pomps}}
}
