% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{partial.cases}
\alias{partial.cases}
\title{Find Partial Cases}
\usage{
partial.cases(data, vrb.nm, ov.min = 1, prop = TRUE, inclusive = TRUE)
}
\arguments{
\item{data}{data.frame or matrix of data.}

\item{vrb.nm}{a character vector of colnames from \code{data} specifying the
variables which will be used to determine the partially observed cases.}

\item{ov.min}{minimum frequency of observed values required per row. If
\code{prop} = TRUE, then this is a decimal between 0 and 1. If \code{prop}
= FALSE, then this is a integer between 0 and \code{length(vrb.nm)}.}

\item{prop}{logical vector of length 1 specifying whether \code{ov.min}
should refer to the proportion of observed values (TRUE) or the count of
observed values (FALSE).}

\item{inclusive}{logical vector of length 1 specifying whether the case
should be included if the frequency of observed values in a row is exactly
equal to \code{ov.min}.}
}
\value{
logical vector of length = \code{nrow(data)} with names =
  \code{rownames(data)} specifying if the frequency of observed values is
  greater than (or equal to, if \code{inclusive} = TRUE) \code{ov.min}.
}
\description{
\code{partial.cases} indicates which cases are at least partially observed,
given a specified frequency of observed values across a set of columns. This
function builds off \code{\link[stats]{complete.cases}}. While
\code{complete.cases} requires completely observed cases,
\code{partial.cases} allows the user to specify the frequency of columns
required to be observed. The default arguments are equal to
\code{complete.cases}.
}
\examples{
cases2keep <- partial.cases(data = airquality,
   vrb.nm = c("Ozone","Solar.R","Wind"), ov.min = .66)
airquality2 <- airquality[cases2keep, ] # all cases with 2/3 variables observed
cases2keep <- partial.cases(data = airquality,
   vrb.nm = c("Ozone","Solar.R","Wind"), ov.min = 1, prop = TRUE, inclusive = TRUE)
complete_cases <- complete.cases(airquality)
identical(x = unname(cases2keep),
   y = complete_cases) # partial.cases(ov.min = 1, prop = TRUE,
   # inclusive = TRUE) = complete.cases()
}
\seealso{
\code{\link[stats]{complete.cases}}
   \code{\link{rowNA}}
   \code{\link{ncases}}
}
