% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diary_functions.R
\name{length_by}
\alias{length_by}
\title{Length of a (Atomic) Vector by Group}
\usage{
length_by(x, grp, na.rm = FALSE, sep = ".")
}
\arguments{
\item{x}{atomic vector.}

\item{grp}{atomic vector or list of atomic vectors (e.g., data.frame)
specifying the groups. The atomic vector(s) must be the length of x or else
an error is returned.}

\item{na.rm}{logical vector of length 1 specifying whether to include (FALSE)
or exclude (TRUE) missing values.}

\item{sep}{character vector of length 1 specifying what string should
separate different group values when naming the return object. This
argument is only used if grp is a list of atomic vectors (e.g.,
data.frame).}
}
\value{
integer vector of length = \code{length(levels(interaction(grp)))}
  with names = \code{length(levels(interaction(grp)))} providing the number
  of elements (excluding missing values if \code{na.rm} = TRUE) in each
  group.
}
\description{
\code{length_by} computes the the length of a (atomic) vector by group. The
argument \code{na.rm} can be used to include (FALSE) or exclude (TRUE)
missing values.
}
\examples{

length_by(x = mtcars$"mpg", grp = mtcars$"gear")
length_by(x = airquality$"Ozone", grp = airquality$"Month", na.rm = FALSE)
length_by(x = airquality$"Ozone", grp = airquality$"Month", na.rm = TRUE)

}
\seealso{
\code{\link{lengths_by}}
   \code{\link{length}}
   \code{\link{agg}}
}
