% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quest_functions.R
\name{center_by}
\alias{center_by}
\title{Centering and/or Standardizing a Numeric Vector by Group}
\usage{
center_by(x, grp, center = TRUE, scale = FALSE)
}
\arguments{
\item{x}{numeric vector.}

\item{grp}{list of atomic vector(s) and/or factor(s) (e.g., data.frame)
containing the groups. They should each have same length as \code{x}. It
can also be an atomic vector or factor, which will then be made the first
element of a list internally.}

\item{center}{logical vector with length 1 specifying whether group-mean
centering should be done.}

\item{scale}{logical vector with length 1 specifying whether group-SD scaling
should be done.}
}
\value{
numeric vector of \code{x} centered and/or standardized by group with
  the same names as \code{x}.
}
\description{
\code{center_by} centers and/or standardized a numeric vector by group. This
is sometimes called group-mean centering and/or group-SD standardizing.
}
\details{
\code{center_by} first coerces \code{x} to a matrix in preparation for the
core of the function, which is essentially: \code{lapply(X = split(x = x, f =
grp), FUN = scale.default)}. If the coercion results in a non-numeric matrix
(e.g., \code{x} is a character vector or factor), then an error is returned.
An error is also returned if \code{x} and the elements of \code{grp} do not
have the same length.
}
\examples{
chick_data <- as.data.frame(ChickWeight) # because the "groupedData" class calls
   # `[.groupedData`, which is different than `[.data.frame`
center_by(x = ChickWeight[["weight"]], grp = ChickWeight[["Chick"]])
center_by(x = setNames(obj = ChickWeight[["weight"]], nm = row.names(ChickWeight)),
   grp = ChickWeight[["Chick"]]) # with names
tmp_nm <- c("Type","Treatment") # b/c Roxygen2 doesn't like a c() within a []
center_by(x = as.data.frame(CO2)[["uptake"]], grp = as.data.frame(CO2)[tmp_nm],
   scale = TRUE) # multiple grouping vectors
}
\seealso{
\code{\link{centers_by}}
   \code{\link{center}}
   \code{\link{centers}}
   \code{\link{scale.default}}
}
