% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyze_palette.R
\name{analyze_palette}
\alias{analyze_palette}
\title{Analyze a categorical color palette}
\usage{
analyze_palette(
  palette,
  cvd = c(protan = 0, deutan = 0, tritan = 0),
  bg = NULL,
  metric = c("ciede2000", "din99d", "cie76")
)
}
\arguments{
\item{palette}{Either a matrix of RGB values (with values between 0 and 1),
a data frame with RGB values, or a character vector of hex colors.}

\item{cvd}{Color vision deficiency adaptation. This must be a named
vector with names \code{protan}, \code{deutan}, and \code{tritan} and values
between 0 and 1, where 0 means no adaptation and 1 means full
adaptation.}

\item{bg}{Background color to consider (but not include) when
generating the palette. This is useful to avoid colros that are too
close to the background/canvas color. If \code{NULL} (the default), the
background color is not considered at all. Any color that is convertable
via \code{\link[grDevices]{col2rgb}} is acceptable, including hex colors.}

\item{metric}{The color metric to use for the color distance
matrix.}
}
\value{
A list of lists, one for each type of color vision deficiency plus
normal vision. Each list contains \code{difference_matrix}, \code{min_distances}, and
\code{bg_min_distance}
}
\description{
Analyze a categorical color palette with respect to
the differences between the colors in the palette.
}
\examples{
pal <- qualpal(5)
analyze_palette(pal$hex, cvd = c(protan = 1))

}
\seealso{
\code{\link[=qualpal]{qualpal()}}
}
