% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evalQspray}
\alias{evalQspray}
\title{Evaluate a 'qspray' object}
\usage{
evalQspray(qspray, values_re, values_im = NULL)
}
\arguments{
\item{qspray}{a \code{qspray} object}

\item{values_re}{vector of the real parts of the values; each element of 
\code{as.character(values_re)} must be a quoted integer or a quoted fraction}

\item{values_im}{vector of the imaginary parts of the values; each element of 
\code{as.character(values_im)} must be a quoted integer or a quoted fraction}
}
\value{
A \code{bigq} number if \code{values_im=NULL}, a pair of \code{bigq} 
  numbers otherwise: the real part and the imaginary part of the result.
}
\description{
Evaluation of the multivariate polynomial represented by a 
  \code{qspray} object.
}
\examples{
x <- qlone(1); y <- qlone(2)
P <- 2*x + "1/2"*y
evalQspray(P, c("2", "5/2", "99999")) # "99999" will be ignored
}
