% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qx_functions.R
\name{qd_save}
\alias{qd_save}
\title{qd_save}
\usage{
qd_save(object, file,
         compress_level = qopt("compress_level"),
         shuffle = qopt("shuffle"),
         warn_unsupported_types = qopt("warn_unsupported_types"),
         nthreads = qopt("nthreads"))
}
\arguments{
\item{object}{The object to save.}

\item{file}{The file name/path.}

\item{compress_level}{The compression level used (the initial value is 3L).

The maximum and minimum possible values depend on the version of the ZSTD library used.
As of ZSTD 1.5.6 the maximum compression level is 22, and the minimum is -131072.
Usually, values in the low positive range offer very good performance in terms
of speed and compression.}

\item{shuffle}{Whether to allow byte shuffling when compressing data (the initial value is TRUE).}

\item{warn_unsupported_types}{Whether to warn when saving an object with an unsupported type (the initial value is TRUE).}

\item{nthreads}{The number of threads to use when compressing data (the initial value is 1L).}
}
\value{
No value is returned. The file is written to disk.
}
\description{
Saves an object to disk using the \code{qdata} format.
}
\examples{
x <- data.frame(int = sample(1e3, replace=TRUE),
         num = rnorm(1e3),
         char = sample(state.name, 1e3, replace=TRUE),
         stringsAsFactors = FALSE)
myfile <- tempfile()
qd_save(x, myfile)
x2 <- qd_read(myfile)
identical(x, x2) # returns TRUE
}
