% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qfa4.1.R
\name{sar.eq.test}
\alias{sar.eq.test}
\title{Wald Test and Confidence Band for Equality of Granger-Causality in Two Samples}
\usage{
sar.eq.test(A1, A1.sim, A2, A2.sim, sel.lag = NULL, sel.tau = NULL)
}
\arguments{
\item{A1}{matrix of selected SAR coefficients for sample 1}

\item{A1.sim}{simulated bootstrap samples from \code{sar.eq.bootstrap()} for sample 1}

\item{A2}{matrix of selected SAR coefficients for sample 2}

\item{A2.sim}{simulated bootstrap samples from \code{sar.eq.bootstrap()} for sample 2}

\item{sel.lag}{indices of time lags for Wald test (default = \code{NULL}: all lags)}

\item{sel.tau}{indices of quantile levels for Wald test (default = \code{NULL}: all quantiles)}
}
\value{
a list with the following elements:
  \item{test}{list of Wald test result containing \code{wald} and \code{p.value}}
  \item{D.u}{matrix of upper limits of 95\% confidence band for \code{A1 - A2}}
  \item{D.l}{matrix of lower limits of 95\% confidence band for \code{A1 - A2}}
}
\description{
This function computes Wald test and confidence band for equality of Granger-causality in two samples
using bootstrap samples generated by \code{sar.eq.bootstrap()} based on the spline autoregression (SAR) models
of quantile series (QSER).
}
\examples{
y11 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y21 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
y12 <- stats::arima.sim(list(order=c(1,0,0), ar=0.5), n=64)
y22 <- stats::arima.sim(list(order=c(1,0,0), ar=-0.5), n=64)
tau <- seq(0.1,0.9,0.05)
y1.sar <- qspec.sar(cbind(y11,y21),tau=tau,p=1)
y2.sar <- qspec.sar(cbind(y12,y22),tau=tau,p=1)
A1.sim <- sar.eq.bootstrap(y1.sar$qser,y1.sar$fit,y2.sar$fit,index=c(1,2),nsim=5)
A2.sim <- sar.eq.bootstrap(y2.sar$qser,y2.sar$fit,y1.sar$fit,index=c(1,2),nsim=5)
A1 <- sar.gc.coef(y1.sar$fit,index=c(1,2))
A2 <- sar.gc.coef(y2.sar$fit,index=c(1,2))
test <- sar.eq.test(A1,A1.sim,A2,A2.sim,sel.lag=NULL,sel.tau=NULL)
}
