% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{bland_altman}
\alias{bland_altman}
\title{Bland-Altman agreement plots.}
\usage{
bland_altman(
  object = NULL,
  formula = NULL,
  data = NULL,
  pch = 20,
  size = 1,
  col = "black",
  transform = FALSE,
  ...
)
}
\arguments{
\item{object}{When chaining, this holds an object produced in the earlier portions of the chain. Most users can safely ignore this argument. See details and examples.}

\item{formula}{A formula with shape: y ~ x (see details).}

\item{data}{A data frame where the variables in the \code{formula} can be found.}

\item{pch}{Symbol for plotting data.}

\item{size}{Size of the symbol using to plot data.}

\item{col}{Colour used for the symbol to plot data.}

\item{transform}{Logical, should ratios instead of difference be used to construct the plot?}

\item{...}{Further arguments passed to \code{\link[ggformula]{gf_point}}.}
}
\description{
Bland-Altman agreement plots.
}
\details{
\code{bland_altman} constructs Bland-Altman agreement plots.

Variables in \code{formula} are continuous paired observations. When the distribution of the outcome
is not normal, but becomes normal with a log-transformation, \code{bland_altman} can plot the ratio between
outcomes (difference in the log scale) by using option \code{transform = TRUE}.
}
\examples{
data(wright, package = "ISwR")

wright |>
  bland_altman(mini.wright ~ std.wright,
    pch = 16,
    ylab = "Large-mini expiratory flow rate (l/min)",
    xlab = "Mean expiratory flow rate (l/min)"
  ) |>
  gf_labs(
    y = "Large-mini expiratory flow rate (l/min)",
    x = "Mean expiratory flow rate (l/min)"
  )

data(Sharples)

Sharples |>
  bland_altman(srweight ~ weight, transform = TRUE) |>
  gf_labs(x = "Mean of weights (kg)", y = "Measured weight / Self-reported weight")
}
