% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quorum.R
\name{quorum_functions}
\alias{quorum_functions}
\alias{quorum_all}
\alias{quorum_any}
\title{Create quorum functions for biproportional apportionment}
\usage{
quorum_all(any_district, total)

quorum_any(any_district, total)
}
\arguments{
\item{any_district}{Vote threshold a party must reach in \emph{at least} one
district. Used as share of total votes within a district if less than 1
otherwise as number of votes. Must be greater than 0. Uses
\code{\link[=reached_quorum_any_district]{reached_quorum_any_district()}}.}

\item{total}{Vote threshold a party must reach for all votes cast. Used as
share of total votes if less than 1. Otherwise as number of votes. Note that
votes are not weighted with \code{\link[=weight_list_votes]{weight_list_votes()}} across districts. Must be
greater than 0. Uses \code{\link[=reached_quorum_total]{reached_quorum_total()}}.}
}
\value{
a function which, when called with \verb{function(votes_matrix)}, returns
a boolean vector with length equal to the number of lists/parties
(\code{votes_matrix} rows). The vector shows whether a party has reached any/all
quorums.
}
\description{
\code{quorum_any()} and \code{quorum_all()} are used for the \code{quorum} parameter in
\code{\link[=biproporz]{biproporz()}}/\code{\link[=pukelsheim]{pukelsheim()}} and help describe how quorums should be
applied prior to seat distributions.
}
\details{
There's a difference in how the functions work. With \code{quorum_any},
\emph{at least one} quorum must be reached. With \code{quorum_all} \emph{all}
(i.e. both) quorums must be reached. If you only use one parameter,
\code{quorum_any()} and \code{quorum_all()} are identical.
}
\examples{
votes_matrix = matrix(c(502, 55, 80, 10, 104, 55, 0, 1), ncol = 2)
dimnames(votes_matrix) <- list(c("A", "B", "C", "D"), c("Z1", "Z2"))
seats = c(Z1 = 50, Z2 = 20)

# use as parameter in biproporz or pukelsheim (general use case)
biproporz(votes_matrix, seats,
          quorum = quorum_any(any_district = 0.1, total = 100))

biproporz(votes_matrix, seats,
          quorum = quorum_all(any_district = 0.1, total = 100))

biproporz(votes_matrix, seats, quorum = quorum_any(any_district = 0.1))

biproporz(votes_matrix, seats, quorum = quorum_any(total = 100))

biproporz(votes_matrix, seats, quorum = quorum_any(total = 0.5))

# the quorum parameter also accepts vectors (e.g. calculated elsewhere)
biproporz(votes_matrix, seats, quorum = c(FALSE, TRUE, TRUE, TRUE))

}
\seealso{
\code{\link[=apply_quorum]{apply_quorum()}} for standalone quorum calculations
}
