% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_date.R
\name{calculate_test_date}
\alias{calculate_test_date}
\title{Calculate pregnancy test date}
\usage{
calculate_test_date(
  start_date,
  start_type = c("LMP", "conception", "transfer_day_3", "transfer_day_5",
    "transfer_day_6"),
  cycle = 28,
  test_type = c("urine", "blood")
)
}
\arguments{
\item{start_date}{Date or character string representing a date, e.g. "YYYY-MM-DD".
The starting reference date. The interpretation of this date depends on the
\code{start_type} parameter.}

\item{start_type}{character. One of:
\itemize{
\item "LMP": Last Menstrual Period date (default)
\item "conception": Date of conception
\item "transfer_day_3": Date of day 3 embryo transfer
\item "transfer_day_5": Date of day 5 embryo transfer
\item "transfer_day_6": Date of day 6 embryo transfer
}}

\item{cycle}{numeric. Length of menstrual cycle in days. Only used when
\code{start_type = "LMP"}. Must be between 20 and 44 days. Defaults to 28 days.}

\item{test_type}{character. One of:
\itemize{
\item "urine": Home pregnancy test (default)
\item "blood": Blood test at clinic
}}
}
\value{
Returns a Date object invisibly representing the recommended test date.
Also prints informative messages showing:
\itemize{
\item The recommended date for a urine test
\item The recommended date for a blood test
}
}
\description{
Calculates the recommended date for taking a pregnancy test based on a start
date and type. The function supports both urine and blood tests, with blood
tests typically being viable 2 days earlier than urine tests.
}
\details{
The test date is calculated as follows:
\enumerate{
\item First, the ovulation date is calculated (see \code{\link[=calculate_due_date]{calculate_due_date()}} for details)
\item For urine tests: 14 days are added to the ovulation date
\item For blood tests: 12 days are added to the ovulation date
}

Blood tests can typically detect pregnancy earlier than urine tests due to their
greater sensitivity in detecting hCG hormone levels.

If \code{start_date} is a character string, the conversion to a \code{Date}
is handled by \code{anytime::anydate()}.
}
\examples{
# Calculate test date from last menstrual period
calculate_test_date("2025-01-31")

# Calculate for blood test from conception date
calculate_test_date(
  start_date = "5023-02-14",
  start_type = "conception",
  test_type = "blood"
)

# Calculate from day 5 embryo transfer
calculate_test_date(
  as.Date("2025-02-19"),
  start_type = "transfer_day_5"
)

# Calculate with non-standard cycle length
calculate_test_date("2025-01-31", cycle = 35)

}
\seealso{
\itemize{
\item \code{\link[=calculate_due_date]{calculate_due_date()}} for calculating the estimated due date
}
}
