% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbeta_rs2.R
\name{rbeta_rs2}
\alias{rbeta_rs2}
\title{Random Variable From a Beta Distribution (User Range)}
\usage{
rbeta_rs2(n = 10, bmean, bsd, blow = 0, bhigh = 1)
}
\arguments{
\item{n}{The number of random numbers
to generate.}

\item{bmean}{The population mean.}

\item{bsd}{The population standard
deviation. If \code{bsd} is zero or
negative, all random numbers will be
equal to \code{bmean}.}

\item{blow}{The lower bound of the
target range.}

\item{bhigh}{The upper bound of the
target range.}
}
\value{
A vector of the generated
random numbers.
}
\description{
Generate random numbers
from a beta distribution, rescaled to
have user-specified population mean
and standard deviation, and within a
specific range.
}
\details{
First, specify the two parameters,
\code{shape1} and \code{shape2}, and the
desired population mean and standard
deviation. The random numbers, drawn
from a beta distribution by
\code{\link[stats:Beta]{stats::rbeta()}} will then be
rescaled to the desired population range.
}
\examples{
set.seed(90870962)
x <- rbeta_rs2(n = 5000,
               bmean = .80,
               bsd = .10,
               blow = .00,
               bhigh = .95)
mean(x)
sd(x)
hist(x)
y <- rbeta_rs2(n = 5000,
               bmean = 4,
               bsd = 3,
               blow = -10,
               bhigh = 10)
mean(y)
sd(y)
hist(y)

}
