% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_format_directory_raw}
\alias{utils_format_directory_raw}
\title{Format raw directory for further processing}
\usage{
utils_format_directory_raw(df, name)
}
\arguments{
\item{df}{A raw directory dataframe as output by
\code{\link{utils_load_directories_csv}}.}

\item{name}{Directory name provided as a character string.}
}
\value{
A dataframe.
}
\description{
Takes a raw directory dataframe (just loaded), adds a column with the
corresponding directory name, replaces all \code{NA} entries with an empty
string, clear all entries of unwanted blank characters, format page number
as integer, returns the output with the directory name column in first
position.
}
\examples{
\dontrun{
  directory <- data.frame(
    page = c("71", "71"),
    surname = c("ABOT     ", " ABRCROMBIE"), forename = c("Wm.", "Alex"),
    occupation = c("wine and    spirit mercht", "    bkr"),
    addresses = c(
      "depot -; 1820 London    st. ; house, Mary hill.*",
      "workshop,,12 &;Dixon st.; residence,    Craigrownie, Cove.$   "
    ),
    stringsAsFactors = FALSE
  )
  utils_format_directory_raw(directory, "1861-1862")
}
}
