% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.r
\name{general_split_address_numbers_bodies}
\alias{general_split_address_numbers_bodies}
\title{Mutate operation(s) in Scottish post office general directory data.frame
column(s)}
\usage{
general_split_address_numbers_bodies(
  directory,
  regex_split_address_numbers,
  regex_split_address_body,
  regex_split_address_empty,
  ignore_case_filter,
  ignore_case_match
)
}
\arguments{
\item{directory}{A Scottish post office general directory in the form
of a data.frame or other object that inherits from the data.frame class
such as a \code{\link[tibble]{tibble}}. Columns must at least include
\code{address.trade} and \code{address.house}.}

\item{regex_split_address_numbers}{Regex to use to match address number(s).}

\item{regex_split_address_body}{Regex to use to match address body(/ies).}

\item{regex_split_address_empty}{Regex to use to match empty address entries.}

\item{ignore_case_filter}{Boolean specifying whether case should be ignored
(\code{TRUE}) or not (\code{FALSE}) for using one of the regexes above as filtering
regex in \code{\link{utils_regmatches_if_found}}.}

\item{ignore_case_match}{Boolean specifying whether case should be ignored
(\code{TRUE}) or not (\code{FALSE}) for using one of the regexes above as matching
regex in \code{\link{utils_regmatches_if_found}}.}
}
\value{
A data.frame of the same class as the one provided in \code{directory};
columns include at least \code{address.trade.number}, \code{address.trade.body},
\code{address.house.number} and \code{address.house.body}.
}
\description{
Attempts to separate number from body of address entries in the Scottish
post office general directory data.frame provided
}
