% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survival.R
\name{plot_km}
\alias{plot_km}
\title{Basic survival analysis plot}
\usage{
plot_km(omicsData)
}
\arguments{
\item{omicsData}{A pmartR data object of any class, which has a `group_df` attribute that is usually created by the `group_designation()` function}
}
\value{
a Kaplan-Meier curve
}
\description{
Implements overall survival analysis or progression-free survival analysis, depending upon the datatypes supplied to
surv_designation, and plot the resulting Kaplan-Meier curve.
}
\examples{
\dontshow{if (requireNamespace("pmartRdata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{
library(MSomicsSTAT)
library(OvarianPepdataBP)
attr(tcga_ovarian_pepdata_bp, "survDF") <- list(t_death = "survival_time",
                                                ind_death = "vital_status")
plot_km(omicsData = tcga_ovarian_pepdata_bp)

# Add covariates to "survDF" attribute
attr(tcga_ovarian_pepdata_bp, "survDF") <- list(
  t_death = "survival_time",
  ind_death = "vital_status",
  covariates = "age_at_initial_pathologic_diagnosis"
)
plot_km(omicsData = tcga_ovarian_pepdata_bp)
}
\dontshow{\}) # examplesIf}
}
