% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Phy-Sigma-R.R
\name{Phy_Sigma_R}
\alias{Phy_Sigma_R}
\title{Pr Sigma as a function of wavelength}
\usage{
Phy_Sigma_R(w.length, use.cached.mult = FALSE)
}
\arguments{
\item{w.length}{numeric array of wavelength (nm)}

\item{use.cached.mult}{logical ignored}
}
\value{
a numeric array with values for Sigma
}
\description{
Pr Sigma as a function of wavelength, calculated by interpolation from data
for Type I Phytochrome as compiled by Mancinelli (1994).
}
\examples{
with(sun.data, Phy_Sigma_R(w.length))
with(sun.data, Phy_Sigma_R(w.length, TRUE))

}
\references{
Mancinelli, A.L. (1994) The physiology of phytochrome action. In
Photomorphogenesis in plants, 2nd edition. R.E. Kendrick and G.H.M.
Kronenberg, eds. Kluwer Academic Publishers, Dordrecht, pp. 211-269. ISBN
978-0-7923-2551-2 (print), 978-94-011-1884-2 (on-line).
\doi{10.1007/978-94-011-1884-2_10}
}
\seealso{
\code{\link[photobiologyPlants]{Phy_Sigma}},
  \code{\link[photobiologyPlants]{Pfr_Ptot}} and
  \code{\link[photobiologyPlants]{Pfr_Ptot_R_FR}}
}
