% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pm_explore.R
\name{pm_list_genera}
\alias{pm_list_genera}
\title{List genera in the Peruvian mammal backbone}
\usage{
pm_list_genera(order = NULL, family = NULL)
}
\arguments{
\item{order}{Optional character vector with one or more taxonomic orders
to keep. If \code{NULL} (default), no filter is applied by order.
Invalid order names will generate a warning.}

\item{family}{Optional character vector with one or more families to keep.
If \code{NULL} (default), no filter is applied by family.
Invalid family names will generate a warning.}
}
\value{
A tibble with one row per genus and the following columns:
\itemize{
\item \code{order} – taxonomic order.
\item \code{family} – family name.
\item \code{genus} – genus name.
\item \code{n_species} – number of species in the genus.
\item \code{n_endemic} – number of endemic species in the genus.
}
Returns an empty tibble with the same structure if no records match
the specified filters.
}
\description{
Summarises the number of species and endemic species per genus.
Optionally restricts the output to one or more orders and/or families.
Genera with missing values are excluded from the results.
}
\details{
The function validates input parameters and warns if invalid order or
family names are provided. It also warns if the filters result in an
empty dataset.
}
\examples{
# All genera
pm_list_genera()

# Genera within Chiroptera (bats)
pm_list_genera(order = "Chiroptera")

# Multiple orders
pm_list_genera(order = c("Didelphimorphia", "Chiroptera"))

# Genera within a specific family
bat_genera <- pm_list_genera(family = "Phyllostomidae")

# Count total endemic species in a family
sum(bat_genera$n_endemic)

# Combination of filters
pm_list_genera(order = "Chiroptera", family = "Phyllostomidae")


}
