% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-access.R
\name{get_threatened_database}
\alias{get_threatened_database}
\title{Get Threatened Species Database}
\usage{
get_threatened_database(type = c("original", "updated"))
}
\arguments{
\item{type}{Character string specifying which database version to retrieve.
Options are:
\itemize{
  \item \code{"original"} (default): Original nomenclature from DS 043-2006-AG (2006)
  \item \code{"updated"}: Updated nomenclature with current taxonomic consensus
}}
}
\value{
A tibble containing the threatened species database.
}
\description{
Retrieves the threatened plant species database for Peru. This function
provides controlled access to the internal datasets used by the package.
}
\note{
This function is primarily for advanced users who need direct access
to the database structure. For most use cases, use the higher-level
functions: \code{\link{is_threatened_peru}} or \code{\link{is_ds043_2006_ag}}.
}
\section{Database Structure}{

**Original Database** (\code{type = "original"}):
\itemize{
  \item ~777 species as listed in DS 043-2006-AG
  \item Supports quaternomial names (Rank 4)
  \item Includes both accepted names and synonyms
  \item Columns: scientific_name, genus, species, tag, infraspecies,
    tag_2, infraspecies_2, threat_category, accepted_name_author,
    taxonomic_status, accepted_name, family, protected_ds_043
}

**Updated Database** (\code{type = "updated"}):
\itemize{
  \item Updated nomenclature using WCVP and POWO
  \item Supports trinomial names (Rank 3 maximum)
  \item Only accepted names (synonyms resolved)
  \item Columns: scientific_name, genus, species, tag_acc, infraspecies,
    threat_category, accepted_name_author, taxonomic_status,
    accepted_name, family, protected_ds_043
}
}

\section{Threat Categories}{

\describe{
  \item{CR}{Critically Endangered}
  \item{EN}{Endangered}
  \item{VU}{Vulnerable}
  \item{NT}{Near Threatened}
}
}

\section{Legal Context}{

Data based on Supreme Decree DS 043-2006-AG, Ministry of Agriculture,
Peru (July 13, 2006), which establishes the official list of threatened
wild flora species in Peru.
}

\examples{
\donttest{
# Get original database
db_original <- get_threatened_database(type = "original")
str(db_original)
nrow(db_original)

# Get updated database
db_updated <- get_threatened_database(type = "updated")
str(db_updated)

# Compare number of species
n_original <- nrow(db_original)
n_updated <- nrow(db_updated)
cat("Original:", n_original, "| Updated:", n_updated, "\n")

# Count by threat category
table(db_original$threat_category)

# Find critically endangered orchids
orchids <- db_original[db_original$family == "ORCHIDACEAE" &
                       db_original$threat_category == "CR", ]
head(orchids$scientific_name)
}
}
\seealso{
\code{\link{is_threatened_peru}} to check threat status of species
\code{\link{is_ds043_2006_ag}} to check DS 043 protection status
}
