% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apa_num.R
\name{apa_p}
\alias{apa_p}
\alias{printp}
\alias{print_p}
\title{Prepare Numeric Values for Printing as p value}
\usage{
apa_p(x, digits = 3L, na_string = "", add_equals = FALSE)

printp(x, digits = 3L, na_string = "", add_equals = FALSE)

print_p(x, digits = 3L, na_string = "", add_equals = FALSE)
}
\arguments{
\item{x}{Numeric. The \emph{p} value(s) to report.}

\item{digits}{Integer. The desired number of digits after the decimal point, passed on to \code{\link{formatC}}.}

\item{na_string}{Character. String to print if any element of \code{x} is \code{NA}.}

\item{add_equals}{Logical. Indicates if the output string should be
prepended with an \code{=}.}
}
\value{
An object of the same class as \code{x} with all numeric values converted
to character.
}
\description{
Convenience wrapper for \code{\link{apa_num}} to print \emph{p} values.
}
\examples{
apa_p(0.05)
apa_p(0.0005)
apa_p(0.99999999)
apa_p(c(.001, 0), add_equals = TRUE)
}
\seealso{
\code{\link[=apa_num]{apa_num()}}, \code{\link[=apa_df]{apa_df()}}
}
