% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/object_catalog_search.R
\name{ps1_cone}
\alias{ps1_cone}
\title{Do a cone search of the PS1 catalog}
\usage{
ps1_cone(
  ra,
  dec,
  r_arcmin = 0.05,
  table = c("mean", "stack", "detection", "forced_mean"),
  release = c("dr2", "dr1"),
  columns = NULL,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{ra}{(degrees) J2000 Right Ascension}

\item{dec}{(degrees) J2000 Declination}

\item{r_arcmin}{(arcmins) Search radius (<= 30 arcmins)}

\item{table}{"mean"(default), "stack", "detection" or "forced_mean"}

\item{release}{"dr1" or "dr2"(default)}

\item{columns}{list of column names to include (NULL means use defaults)}

\item{verbose}{print info about request}

\item{...}{other parameters (e.g., nDetections.min = 2)}
}
\value{
data.frame
}
\description{
Do a cone search of the PS1 catalog
}
\examples{
\dontrun{
ps1_cone(ra = 139.334,dec = 68.635,r_arcmin = 0.05, nDetections.gt = 1)
}
}
