% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logger-provider-stdout.R
\docType{data}
\name{logger_provider_stdstream}
\alias{logger_provider_stdstream}
\title{Logger provider to write to the standard output or standard error or
to a file}
\value{
\code{logger_provider_stdstream$new()} returns an \link[otel:otel_logger_provider]{otel::otel_logger_provider}
object.

\code{logger_provider_stdstream$options()} returns a named list, the current
values of the options.
}
\description{
Writes logs to the standard output or error, or to a file. Useful for
debugging.
}
\section{Usage}{
Externally:

\if{html}{\out{<div class="sourceCode">}}\preformatted{OTEL_LOGS_EXPORTER=console
OTEL_LOGS_EXPORTER=stderr
}\if{html}{\out{</div>}}

From R:

\if{html}{\out{<div class="sourceCode">}}\preformatted{logger_provider_stdstream$new(opts = NULL)
logger_provider_stdstream$options()
}\if{html}{\out{</div>}}
}

\section{Arguments}{
\code{opts}: Named list of options. See below.
}

\section{Options}{
\subsection{Standard stream exporter options}{
\itemize{
\item \code{output}: where to write the output. Can be
\itemize{
\item \code{"stdout"}: write output to the standard output,
\item \code{"stderr"}: write output to the standard error,
\item another string: write output to a file. (To write output to a file
named \code{"stdout"} or \code{"stderr"}, use a \verb{./} prefix.)
}

Value is set from
\itemize{
\item the \code{opts} argument, or
\item the \code{OTEL_R_EXPORTER_STDSTREAM_LOGS_OUTPUT} environment variable, or
\item the \code{OTEL_R_EXPORTER_STDSTREAM_OUTPUT} environment variable, or
\item the default is \code{"stdout"}.
}
}
}
}

\examples{
logger_provider_stdstream$options()
}
\keyword{datasets}
