% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remote.R
\name{orderly_bundle_pack_remote}
\alias{orderly_bundle_pack_remote}
\alias{orderly_bundle_import_remote}
\title{Pack and import bundles with remotes}
\usage{
orderly_bundle_pack_remote(
  name,
  parameters = NULL,
  instance = NULL,
  root = NULL,
  locate = TRUE,
  remote = NULL,
  dest = tempdir()
)

orderly_bundle_import_remote(path, root = NULL, locate = TRUE, remote = NULL)
}
\arguments{
\item{name}{Name of the report to pack (see
\code{\link[=orderly_list]{orderly_list()}}.  A leading \verb{src/} will be removed if
provided, allowing easier use of autocomplete.}

\item{parameters}{Parameters passed to the report. A named list of
parameters declared in the \code{orderly.yml}.  Each parameter
must be a scalar character, numeric, integer or logical.}

\item{instance}{Select instance of the source database to be used,
where multiple instances are configured.  Use a single
\emph{unnamed} character string to indicate an instance to
match.  If given, then this name must be present in all
databases where instances are listed in
\code{orderly_config.yml}, and will be ignored by all database
where instances are not given.  See the "orderly" vignette for
further information.}

\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{remote}{The remote to pack the bundle from, or import into}

\item{dest}{Optional path to write bundle to (a directory
name). By default we use the temporary directory and return the
full path to the created file.}

\item{path}{The path to unpack and import
(a zip file created by \code{orderly_bundle_run})}
}
\description{
Pack a bundle on a remote. This is like calling
\code{\link[=orderly_bundle_pack]{orderly_bundle_pack()}} on the remote and can be used to
extract a long-running report from a server to run (say) on an HPC
system.
}
\details{
The workflow here will typically be:
\enumerate{
\item Use \code{orderly_bundle_pack_remote()} to create a local
copy of a bundle, extracted from a remote. Typically this will
be run from the system where the bundle will be run (an HPC
head-node or another powerful computer).
\item Run the bundle using \code{\link[=orderly_bundle_run]{orderly_bundle_run()}}
\item Re-import the completed bundle using
\code{orderly_bundle_import_remote} which sends the zip
file to the remote and adds it to the archive.
}

Typically these commands will \emph{not} be run from the orderly
root. However, the \code{root} argument may still be used to find
your remote configuration. Alternatively, if your \code{remote}
argument is an orderly remote (e.g.,
\code{\link[=orderly_remote_path]{orderly_remote_path()}}, or \code{orderlyweb}'s
\code{orderlyweb::orderlyweb_remote}) then the \code{root} and
\code{locate} arguments will be ignored and this command can be
run from anywhere. This is the recommended configuration for
running on a HPC system.
}
