% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{orderly_list_metadata}
\alias{orderly_list_metadata}
\title{List reports with only local metadata}
\usage{
orderly_list_metadata(root = NULL, locate = FALSE, include_archive = FALSE)
}
\arguments{
\item{root}{The path to an orderly root directory, or \code{NULL}
(the default) to search for one from the current working
directory if \code{locate} is \code{TRUE}.}

\item{locate}{Logical, indicating if the configuration should be
searched for.  If \code{TRUE} and \code{config} is not given,
then orderly looks in the working directory and up through its
parents until it finds an \code{orderly_config.yml} file.}

\item{include_archive}{Logical, indicating if we should include
reports that are also included in the archive.}
}
\value{
A \code{\link[=data.frame]{data.frame()}} with columns \code{name} and
\code{id}, as for \code{\link[=orderly_list_archive]{orderly_list_archive()}}
}
\description{
List reports that are present only as metadata; these are the
result of doing \code{\link[=orderly_pull_archive]{orderly_pull_archive()}} with
\code{recursive = FALSE}, in which case only metadata was
downloaded and not the report contents itself.
}
\examples{
path <- orderly::orderly_example("minimal")
# No metadata-only reports will be present, unless you have run
# orderly::orderly_pull_archive(..., recursive = FALSE)
orderly::orderly_list_metadata(path)
}
