% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dates.R
\name{convert_date}
\alias{convert_date}
\alias{convert_datetime}
\alias{convert_hms}
\title{Convert from Excel date, datetime or hms number to R Date type}
\usage{
convert_date(x, origin = "1900-01-01", ...)

convert_datetime(x, origin = "1900-01-01", ...)

convert_hms(x)
}
\arguments{
\item{x}{A vector of integers}

\item{origin}{date. Default value is for Windows Excel 2010}

\item{...}{
  Arguments passed on to \code{\link[base:as.Date]{base::as.Date.character}}
  \describe{
    \item{\code{format}}{a \code{\link[base]{character}} string.  If not specified when
    converting from a character representation, it will try
    \code{tryFormats} one by one on the first non-\code{NA} element, and
    give an error if none works.  Otherwise, the processing is via
    \code{\link[base]{strptime}()} whose help page describes available
    conversion specifications.}
    \item{\code{tryFormats}}{\code{\link[base]{character}} vector of \code{format}
    strings to try if \code{format} is not specified.}
    \item{\code{optional}}{\code{\link[base]{logical}} indicating to return \code{NA}
    (instead of signalling an error) if the format guessing does not succeed.}
  }}
}
\value{
A date, datetime, or hms.
}
\description{
Convert from Excel date number to R Date type
}
\details{
Excel stores dates as number of days from some origin day
}
\examples{
# date --
## 2014 April 21st to 25th
convert_date(c(41750, 41751, 41752, 41753, 41754, NA))
convert_date(c(41750.2, 41751.99, NA, 41753))

# datetime --
##  2014-07-01, 2014-06-30, 2014-06-29
x <- c(41821.8127314815, 41820.8127314815, NA, 41819, NaN)
convert_datetime(x)
convert_datetime(x, tz = "Australia/Perth")
convert_datetime(x, tz = "UTC")

# hms ---
## 12:13:14
x <- 0.50918982
convert_hms(x)
}
\seealso{
\code{\link[=wb_add_data]{wb_add_data()}}
}
