% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodSettings.R
\name{settings.summarised_result}
\alias{settings.summarised_result}
\title{Get settings from a summarised_result object.}
\usage{
\method{settings}{summarised_result}(x)
}
\arguments{
\item{x}{A summarised_result object.}
}
\value{
A table with the settings.
}
\description{
Get settings from a summarised_result object.
}
\examples{
library(omopgenerics)
library(dplyr, warn.conflicts = FALSE)

person <- tibble(
  person_id = 1, gender_concept_id = 0, year_of_birth = 1990,
  race_concept_id = 0, ethnicity_concept_id = 0
)
observation_period <- tibble(
  observation_period_id = 1, person_id = 1,
  observation_period_start_date = as.Date("2000-01-01"),
  observation_period_end_date = as.Date("2023-12-31"),
  period_type_concept_id = 0
)
cohort <- tibble(
  cohort_definition_id = 1,
  subject_id = 1,
  cohort_start_date = as.Date("2010-01-01"),
  cohort_end_date = as.Date("2012-01-01")
)
cdm <- cdmFromTables(
  tables = list("person" = person, "observation_period" = observation_period),
  cdmName = "test",
  cohortTables = list("my_cohort" = cohort)
)

result <- summary(cdm$my_cohort)

settings(result)

}
