% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate.R
\name{isResultSuppressed}
\alias{isResultSuppressed}
\title{To check whether an object is already suppressed to a certain min cell count.}
\usage{
isResultSuppressed(result, minCellCount = 5)
}
\arguments{
\item{result}{The suppressed result to check}

\item{minCellCount}{Minimum count of records used when suppressing}
}
\value{
Warning or message with check result
}
\description{
To check whether an object is already suppressed to a certain min cell count.
}
\examples{
x <- dplyr::tibble(
  "result_id" = 1L,
  "cdm_name" = "eunomia",
  "group_name" = "cohort_name",
  "group_level" = "my_cohort",
  "strata_name" = c("sex", "sex &&& age_group", "sex &&& year"),
  "strata_level" = c("Female", "Male &&& <40", "Female &&& 2010"),
  "variable_name" = "number subjects",
  "variable_level" = NA_character_,
  "estimate_name" = "count",
  "estimate_type" = "integer",
  "estimate_value" = c("100", "44", "14"),
  "additional_name" = "overall",
  "additional_level" = "overall"
) |>
  newSummarisedResult()

isResultSuppressed(x)

}
