% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodTidy.R
\name{tidy.summarised_result}
\alias{tidy.summarised_result}
\title{Turn a \verb{<summarised_result>} object into a tidy tibble}
\usage{
\method{tidy}{summarised_result}(x, ...)
}
\arguments{
\item{x}{A \verb{<summarised_result>}.}

\item{...}{For compatibility (not used).}
}
\value{
A tibble.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
Provides tools for obtaining a tidy version of a \verb{<summarised_result>} object.
This tidy version will include the settings as columns, \code{estimate_value} will
be pivotted into columns using \code{estimate_name} as names, and group, strata,
and additional will be splitted.
}
\examples{
{
  library(dplyr)
  library(omopgenerics)

  x <- tibble(
    "result_id" = as.integer(c(1, 2)),
    "cdm_name" = c("cprd", "eunomia"),
    "group_name" = "cohort_name",
    "group_level" = "my_cohort",
    "strata_name" = "sex",
    "strata_level" = "male",
    "variable_name" = "Age group",
    "variable_level" = "10 to 50",
    "estimate_name" = "count",
    "estimate_type" = "numeric",
    "estimate_value" = "5",
    "additional_name" = "overall",
    "additional_level" = "overall"
  ) |>
    newSummarisedResult(settings = tibble(
      "result_id" = c(1, 2), "custom" = c("A", "B")
    ))

  x

  x |> tidy()
}

}
