% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Result.R
\docType{methods}
\name{dbColumnInfo}
\alias{dbColumnInfo}
\alias{dbColumnInfo,AthenaResult-method}
\title{Information about result types}
\usage{
\S4method{dbColumnInfo}{AthenaResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \linkS4class{DBIResult}.}

\item{...}{Other arguments passed on to methods.}
}
\value{
\code{dbColumnInfo()} returns a data.frame with as many rows as there are output fields in the result.
        The data.frame has two columns (field_name, type).
}
\description{
Produces a data.frame that describes the output of a query.
}
\examples{
\dontrun{
# Note:
# - Require AWS Account to run below example.
# - Different connection methods can be used please see `RAthena::dbConnect` documnentation

library(DBI)

# Demo connection to Athena using profile name
con <- dbConnect(noctua::athena())

# Get Column information from query
res <- dbSendQuery(con, "select * from information_schema.tables")
dbColumnInfo(res)
dbClearResult(res)

# Disconnect from Athena
dbDisconnect(con)
}
}
\seealso{
\code{\link[DBI]{dbHasCompleted}}
}
