% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_sc.R
\name{match_map_sc_matrix}
\alias{match_map_sc_matrix}
\title{Match Expression Matrix with Phylostratum Map}
\usage{
match_map_sc_matrix(
  expression_matrix,
  metadata,
  phylomap,
  strata_legend = NULL,
  ...
)
}
\arguments{
\item{expression_matrix}{Expression matrix with genes as rows and cells as columns}

\item{metadata}{Data frame with cell metadata, rownames should match colnames of expression_matrix}

\item{phylomap}{A data frame with two columns: phylostratum assignments and gene IDs}

\item{strata_legend}{A data frame with two columns: phylostratum assignments and name of each stratum. If NULL, numeric labels will be used (default: NULL)}

\item{...}{Additional arguments passed to ScPhyloExpressionSet_from_matrix}
}
\value{
A ScPhyloExpressionSet object
}
\description{
Join single-cell gene expression matrix with a phylostratum mapping to create 
a ScPhyloExpressionSet object.
}
\details{
This function combines phylostratum mapping with expression matrix and metadata to create
a ScPhyloExpressionSet. Only genes present in both the expression matrix and phylomap
will be retained. All discrete metadata columns are converted to factors automatically.
}
