% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{convert_domain}
\alias{convert_domain}
\title{Transfer data from one input domain to another via common latent space}
\usage{
convert_domain(x, new_data, i, j, comp, rowind, colind, ...)
}
\arguments{
\item{x}{The model fit, typically an object of a class that implements a \code{transfer} method}

\item{new_data}{The data to transfer, with the same number of rows as the source data block}

\item{i}{The index of the source data block}

\item{j}{The index of the destination data block}

\item{comp}{A vector of component indices to use in the reconstruction}

\item{rowind}{Optional set of row indices to transfer (default: all rows)}

\item{colind}{Optional set of column indices to transfer (default: all columns)}

\item{...}{Additional arguments passed to the underlying \code{convert_domain} method}
}
\value{
A matrix or data frame representing the transferred data in the target domain
}
\description{
Convert between data representations in a multiblock decomposition/alignment by projecting
the input data onto a common latent space and then reconstructing it in the target domain.
}
\seealso{
\code{\link{project_block}} for projecting a single block of data onto the subspace
}
