% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{tpw}
\alias{tpw}
\title{Truncated Power Method}
\usage{
tpw(Sigma, k, maxIter = 200L, verbose = TRUE, timeLimit = 10L)
}
\arguments{
\item{Sigma}{A matrix. The correlation or covariance matrix, whose sparse PCs will be computed.}

\item{k}{An integer. Target sparsity of the PC.}

\item{maxIter}{(optional) An integer. Maximum number of iterations of the algorithm. Default 200.}

\item{verbose}{(optional) A Boolean. Controls console output. Default TRUE.}

\item{timeLimit}{(optional) An integer. Maximum time in seconds. Default 10.}
}
\value{
An object with 3 fields: `x_best` (p x 1 array containing the sparse PC), `objective_value`, `runtime`.
}
\description{
Returns the leading sparse principal component of a matrix using the truncated power method.
}
\examples{
library(datasets)
TestMat <- cor(datasets::mtcars)
tpw(TestMat, 4)
}
\references{
Yuan, X. T., & Zhang, T. (2013). Truncated power method for sparse eigenvalue problems. The Journal of Machine Learning Research, 14(1), 899-925.
}
