% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dictionary_sugar.R
\name{dictionary_sugar_inc_get}
\alias{dictionary_sugar_inc_get}
\alias{dictionary_sugar_inc_mget}
\title{A Quick Way to Initialize Objects from Dictionaries with Incremented ID}
\usage{
dictionary_sugar_inc_get(dict, .key, ..., .dicts_suggest = NULL)

dictionary_sugar_inc_mget(dict, .keys, ..., .dicts_suggest = NULL)
}
\arguments{
\item{dict}{(\link{Dictionary})\cr
Dictionary from which to retrieve an element.}

\item{.key}{(\code{character(1)})\cr
Key of the object to construct - possibly with a suffix of the form \verb{_<n>} which will be appended to the id.}

\item{...}{(\code{any})\cr
See description of \link{dictionary_sugar}.}

\item{.dicts_suggest}{(named \code{list()})
Named list of \link[=Dictionary]{dictionaries} used to look up suggestions for \code{.key} if \code{.key} does not exist in \code{dict}.}

\item{.keys}{(\code{character()})\cr
Keys of the objects to construct - possibly with suffixes of the form \verb{_<n>} which will be appended to the ids.}
}
\value{
An element from the dictionary.
}
\description{
Covenience wrapper around \link{dictionary_sugar_get} and \link{dictionary_sugar_mget} to allow easier avoidance of ID
clashes which is useful when the same object is used multiple times and the ids have to be unique.
Let \verb{<key>} be the key of the object to retrieve. When passing the \verb{<key>_<n>} to this
function, where \verb{<n>} is any natural number, the object with key \verb{<key>} is retrieved and the
suffix \verb{_<n>} is appended to the id after the object is constructed.
}
\examples{
d = Dictionary$new()
d$add("a", R6::R6Class("A", public = list(id = "a")))
d$add("b", R6::R6Class("B", public = list(id = "c")))
obj1 = dictionary_sugar_inc_get(d, "a_1")
obj1$id

obj2 = dictionary_sugar_inc_get(d, "b_1")
obj2$id

objs = dictionary_sugar_inc_mget(d, c("a_10", "b_2"))
map(objs, "id")

}
