% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk.R
\name{chunk_vector}
\alias{chunk_vector}
\alias{chunk}
\title{Chunk Vectors}
\usage{
chunk_vector(x, n_chunks = NULL, chunk_size = NULL, shuffle = TRUE)

chunk(n, n_chunks = NULL, chunk_size = NULL, shuffle = TRUE)
}
\arguments{
\item{x}{(\code{vector()})\cr
Vector to split into chunks.}

\item{n_chunks}{(\code{integer(1)})\cr
Requested number of chunks.
Mutually exclusive with \code{chunk_size} and \code{props}.}

\item{chunk_size}{(\code{integer(1)})\cr
Requested number of elements in each chunk.
Mutually exclusive with \code{n_chunks} and \code{props}.}

\item{shuffle}{(\code{logical(1)})\cr
If \code{TRUE}, permutes the order of \code{x} before chunking.}

\item{n}{(\code{integer(1)})\cr
Length of vector to split.}
}
\value{
\code{chunk()} returns a \code{integer()} of chunk indices,
\code{chunk_vector()} a \code{list()} of \code{integer} vectors.
}
\description{
Chunk atomic vectors into parts of roughly equal size.
\code{chunk()} takes a vector length \code{n} and returns an integer with chunk numbers.
\code{chunk_vector()} uses \code{\link[base:split]{base::split()}} and \code{chunk()} to split an atomic vector into chunks.
}
\examples{
x = 1:11

ch = chunk(length(x), n_chunks = 2)
table(ch)
split(x, ch)

chunk_vector(x, n_chunks = 2)

chunk_vector(x, n_chunks = 3, shuffle = TRUE)
}
