% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regr_mape.R
\name{mape}
\alias{mape}
\title{Mean Absolute Percent Error}
\usage{
mape(truth, response, sample_weights = NULL, na_value = NaN, ...)
}
\arguments{
\item{truth}{(\code{numeric()})\cr
True (observed) values.
Must have the same length as \code{response}.}

\item{response}{(\code{numeric()})\cr
Predicted response values.
Must have the same length as \code{truth}.}

\item{sample_weights}{(\code{numeric()})\cr
Vector of non-negative and finite sample weights.
Must have the same length as \code{truth}.
The vector gets automatically normalized to sum to one.
Defaults to equal sample weights.}

\item{na_value}{(\code{numeric(1)})\cr
Value that should be returned if the measure is not defined for the input
(as described in the note). Default is \code{NaN}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed response with predicted response in regression tasks.
}
\details{
The Mean Absolute Percent Error is defined as \deqn{
  \frac{1}{n} \sum_{i=1}^n w_i \left| \frac{ t_i - r_i}{t_i} \right|,
 }{
   weighted.mean(abs((t - r) / t), w),
 }
where \eqn{w_i} are normalized sample weights.

This measure is undefined if any element of \eqn{t} is \eqn{0}.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"regr"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{response}
}
}

\examples{
set.seed(1)
truth = 1:10
response = truth + rnorm(10)
mape(truth, response)
}
\references{
de Myttenaere, Arnaud, Golden, Boris, Le Grand, Bénédicte, Rossi, Fabrice (2016).
\dQuote{Mean Absolute Percentage Error for regression models.}
\emph{Neurocomputing}, \bold{192}, 38-48.
ISSN 0925-2312, \doi{10.1016/j.neucom.2015.12.114}.
}
\seealso{
Other Regression Measures: 
\code{\link{ae}()},
\code{\link{ape}()},
\code{\link{bias}()},
\code{\link{ktau}()},
\code{\link{linex}()},
\code{\link{mae}()},
\code{\link{maxae}()},
\code{\link{maxse}()},
\code{\link{medae}()},
\code{\link{medse}()},
\code{\link{mse}()},
\code{\link{msle}()},
\code{\link{pbias}()},
\code{\link{pinball}()},
\code{\link{rae}()},
\code{\link{rmse}()},
\code{\link{rmsle}()},
\code{\link{rrse}()},
\code{\link{rse}()},
\code{\link{rsq}()},
\code{\link{sae}()},
\code{\link{se}()},
\code{\link{sle}()},
\code{\link{smape}()},
\code{\link{srho}()},
\code{\link{sse}()}
}
\concept{Regression Measures}
\concept{regression_measure}
