% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classif_logloss.R
\name{logloss}
\alias{logloss}
\title{Log Loss}
\usage{
logloss(truth, prob, sample_weights = NULL, eps = 1e-15, ...)
}
\arguments{
\item{truth}{(\code{factor()})\cr
True (observed) labels.
Must have the same levels and length as \code{response}.}

\item{prob}{(\code{matrix()})\cr
Matrix of predicted probabilities, each column is a vector of probabilities for a
specific class label.
Columns must be named with levels of \code{truth}.}

\item{sample_weights}{(\code{numeric()})\cr
Vector of non-negative and finite sample weights.
Must have the same length as \code{truth}.
The vector gets automatically normalized to sum to one.
Defaults to equal sample weights.}

\item{eps}{(\code{numeric(1)})\cr
Probabilities are clipped to \code{max(eps, min(1 - eps, p))}.
Otherwise the measure would be undefined for probabilities \code{p = 0} and \code{p = 1}.}

\item{...}{(\code{any})\cr
Additional arguments. Currently ignored.}
}
\value{
Performance value as \code{numeric(1)}.
}
\description{
Measure to compare true observed labels with predicted
probabilities
in multiclass classification tasks.
}
\details{
The Log Loss (a.k.a Benoulli Loss, Logistic Loss, Cross-Entropy Loss) is defined as
\deqn{
  -\frac{1}{n} \sum_{i=1}^n w_i \log \left(  p_i \right )
}{
  -weighted.mean(log(p), w)
}
where \eqn{p_i}{p} is the probability for the true class of observation \eqn{i} and \eqn{w_i} are normalized weights for each observation \eqn{x_i}.
}
\section{Meta Information}{

\itemize{
\item Type: \code{"classif"}
\item Range: \eqn{[0, \infty)}{[0, Inf)}
\item Minimize: \code{TRUE}
\item Required prediction: \code{prob}
}
}

\examples{
set.seed(1)
lvls = c("a", "b", "c")
truth = factor(sample(lvls, 10, replace = TRUE), levels = lvls)
prob = matrix(runif(3 * 10), ncol = 3, dimnames = list(NULL, lvls))
prob = t(apply(prob, 1, function(x) x / sum(x)))
logloss(truth, prob)
}
\seealso{
Other Classification Measures: 
\code{\link{acc}()},
\code{\link{bacc}()},
\code{\link{ce}()},
\code{\link{mauc_aunu}()},
\code{\link{mbrier}()},
\code{\link{mcc}()},
\code{\link{zero_one}()}
}
\concept{Classification Measures}
\concept{classification_measure}
