% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_prediction_regr.R
\name{as_prediction_regr}
\alias{as_prediction_regr}
\alias{as_prediction_regr.PredictionRegr}
\alias{as_prediction_regr.data.frame}
\title{Convert to a Regression Prediction}
\usage{
as_prediction_regr(x, ...)

\method{as_prediction_regr}{PredictionRegr}(x, ...)

\method{as_prediction_regr}{data.frame}(x, ...)
}
\arguments{
\item{x}{(any)\cr
Object to convert.}

\item{...}{(any)\cr
Additional arguments.}
}
\value{
\link{PredictionRegr}.
}
\description{
Convert object to a \link{PredictionRegr}.
}
\examples{
# create a prediction object
task = tsk("mtcars")
learner = lrn("regr.rpart")
learner$train(task)
p = learner$predict(task)

# convert to a data.table
tab = as.data.table(p)

# convert back to a Prediction
as_prediction_regr(tab)

# split data.table into a list of data.tables
tabs = split(tab, cut(tab$truth, 3))

# convert back to list of predictions
preds = lapply(tabs, as_prediction_regr)

# calculate performance in each group
sapply(preds, function(p) p$score())
}
