% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loglm.R
\name{loglm}
\alias{loglm}
\title{Log-linear model}
\usage{
loglm(formula, data)
}
\arguments{
\item{formula, data}{see \code{lm}}
}
\value{
An object of class \code{"micsr"}, see \code{micsr::micsr} for further details.
}
\description{
Estimation of log-linear model; the estimation is done by \code{lm}, but
the correct log-likelihood related quantities are returned
}
\examples{
lm_model <- lm(log(dist) ~ log(speed), cars)
log_model <- loglm(dist ~ log(speed), cars)
coef(lm_model)
coef(log_model)
# same coefficients, supplementary sigma coefficient for `loglm`
logLik(lm_model)
logLik(log_model)
# log_model returns the correct value for the log-likelihood
}
\author{
Yves Croissant
}
\keyword{models}
