% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_stopwords.R
\name{generate_stopwords}
\alias{generate_stopwords}
\title{Generate data frame containing stop words}
\usage{
generate_stopwords(stopwords, combine_with = NULL)
}
\arguments{
\item{stopwords}{Character vector. Vector containing stop words.}

\item{combine_with}{Data frame containing stop words. Optional.
Data frame provided here must have only two columns, namely
\code{word} and \code{lexicon}. This data frame is combined with
the data frame created from \code{stopwords}.
Exemplary data frames are
\itemize{
\item \code{tidytext::stop_words} from the \pkg{tidytext} package, or
\item \code{stopwords_miretrieve} from this package.
}}
}
\value{
Data frame containing stop words.
}
\description{
Generate a data frame containing stop words.
}
\details{
Generate data frame containing stop words from a character vector. This data
frame consists of two columns, namely \code{word}, containing the stop words, and
\code{lexicon}, containing the string "self-defined".
Additionally, the created data frame can be combined with other stop words
containing data frames, e.g. \code{tidytext::stop_words} or
\code{stopwords_miretrieve}.
}
\references{
Silge, Julia, and David Robinson. 2016.
“tidytext: Text Mining and Analysis Using Tidy Data Principles in R.”
JOSS 1 (3). The Open Journal. https://doi.org/10.21105/joss.00037.
}
\seealso{
\code{\link[=combine_stopwords]{combine_stopwords()}}, \link{stopwords_miretrieve}, \link[tidytext:stop_words]{tidytext::stop_words}

Other stopword functions: 
\code{\link{combine_stopwords}()}
}
\concept{stopword functions}
