% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Stein.R
\name{fit.wgpd}
\alias{fit.wgpd}
\title{Maximum likelihood estimation for weighted generalized Pareto distribution}
\usage{
fit.wgpd(xdat, threshold = 0, weightfun = Stein_weights, start = NULL, ...)
}
\arguments{
\item{xdat}{vector of observations}

\item{threshold}{numeric, value of the threshold}

\item{weightfun}{function whose first argument is the length of the weight vector}

\item{start}{optional vector of scale and shape parameters for the optimization routine, defaults to \code{NULL}}

\item{...}{additional arguments passed to the weighting function \code{weightfun}}
}
\value{
a list with components
\itemize{
\item \code{estimate} a vector containing the \code{scale} and \code{shape} parameters (optimized and fixed).
\item \code{std.err} a vector containing the standard errors.
\item \code{vcov} the variance covariance matrix, obtained as the numerical inverse of the observed information matrix.
\item \code{threshold} the threshold.
\item \code{method} the method used to fit the parameter. See details.
\item \code{nllh} the negative log-likelihood evaluated at the parameter \code{estimate}.
\item \code{nat} number of points lying above the threshold.
\item \code{pat} proportion of points lying above the threshold.
\item \code{convergence} logical indicator of convergence.
\item \code{weights} vector of weights for exceedances.
\item \code{exceedances} excess over the threshold, sorted in decreasing order.
}
}
\description{
Weighted maximum likelihood estimation, with user-specified vector of weights.
}
