% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neLht.R
\name{neLht}
\alias{neLht}
\alias{neEffdecomp}
\alias{neEffdecomp.neModel}
\alias{neLht.neModel}
\title{Linear hypotheses for natural effect models}
\usage{
neEffdecomp(model, xRef, covLev, ...)

\method{neEffdecomp}{neModel}(model, xRef, covLev, ...)

neLht(model, ...)

\method{neLht}{neModel}(model, ...)
}
\arguments{
\item{model}{a fitted natural effect model object.}

\item{xRef}{a vector including reference levels for the exposure, \emph{x*} and \emph{x}, at which natural effect components need to be evaluated (see details).}

\item{covLev}{a vector including covariate levels at which natural effect components need to be evaluated (see details).}

\item{...}{additional arguments (passed to \code{\link[multcomp]{glht}}).}
}
\value{
An object of class \code{c("neLht", "glht")} (see \code{\link[multcomp]{glht}}). 
If the bootstrap is used for obtaining standard errors when fitting the \code{\link{neModel}} object, the returned object additionally inherits from class \code{"neLhtBoot"}. 
\code{neEffdecomp} returns an object that additionally inherits from class \code{"neEffdecomp"}.

See \code{\link{neLht-methods}} for methods for \code{neLht} objects (and \code{\link[=coef.glht]{glht-methods}} for additional methods for \code{glht} objects).
}
\description{
\code{neLht} allows to calculate linear combinations of natural effect model parameter estimates.\cr \code{neEffdecomp} automatically extracts relevant causal parameter estimates from a natural effect model.
}
\details{
\code{neLht} is a wrapper of \code{\link[multcomp]{glht}} and offers the same functionality (see `Details' section of  \code{\link[multcomp]{glht}} for details on argument specification). 
It returns objects that inherit from the class \code{"neLht"} in order to make output of their corresponding methods (see \code{\link{neLht-methods}}) more compatible for natural effect models
containing bootstrap variance-covariance matrices and standard errors.

\code{neEffdecomp} is a convenience function that automatically extracts causal parameter estimates from a natural effect model
and derives natural effect components.
That is, natural direct, natural indirect and total causal effect estimates are returned if no exposure-mediator interaction is modelled (i.e. two-way decomposition). 
If mediated interaction is allowed for in the natural effect model, there are two ways of decomposing the total effect into (natural) direct and indirect effects components: 
either as the sum of the pure direct and the total indirect effect or as the sum of the pure indirect and the total direct effect (i.e. three-way decomposition).
In total, five causal effect estimates are returned in this case.

For continuous exposures, default exposure levels at which natural effect components are evaluated are \emph{x*} = 0 and \emph{x} = 1.
For multicategorical exposures, default levels are the reference level of the factor that encodes the exposure variable and the level corresponding to its first dummy variable for \emph{x*} and \emph{x}, respectively.  
If one wishes to evaluate natural effect components at different reference levels (e.g. if the natural effect model includes mediated interaction, quadratic or higher-order polynomial terms for the exposure; see examples), 
these can be specified as a vector of the form \code{c(x*,x)} via the \code{xRef} argument.

If applicable, covariate levels at which natural effect components are evaluated can also be specified. This is particularly useful for natural effect models encoding effect modification by baseline covariates (e.g. moderated mediation).
By default, these levels are set to 0 for continuous covariates and to the reference level for categorical covariates coded as factors. 
Different covariate levels can be specified via the \code{covLev} argument, which requires a vector including valid levels for covariates that are specified in the natural effect model (or a subset of covariates that are specified as modifiers of either the natural direct or indirect effect or both).
Levels need to be preceded by the name of the corresponding covariate, e.g., \code{covLev = c(gender = "M", age = 30)}. Covariates for which the levels are left unspecified are set to their default levels (see examples). 
The \code{\link{print}} and \code{\link[=summary.neLht]{summary}} functions for \code{neEffdecomp} objects return the covariate levels at which natural effect components are evaluated. 
No specific levels are returned for covariates that are not specified as modifier since effect decomposition is independent of the level of these covariates (see examples).
}
\note{
\code{neEffdecomp} is internally called by \code{\link{plot.neModel}} to create confidence interval plots for \code{neModel} objects.
}
\examples{
data(UPBdata)

impData <- neImpute(UPB ~ att * negaff + gender + educ + age, 
                    family = binomial, data = UPBdata)
neMod <- neModel(UPB ~ att0 * att1 + gender + educ + age, 
                 family = binomial, expData = impData, se = "robust")

lht <- neLht(neMod, linfct = c("att0 = 0", "att0 + att0:att1 = 0", 
                               "att1 = 0", "att1 + att0:att1 = 0", 
                               "att0 + att1 + att0:att1 = 0"))
summary(lht)

## or obtain directly via neEffdecomp
eff <- neEffdecomp(neMod)
summary(eff)

## changing reference levels for multicategorical exposures
UPBdata$attcat <- factor(cut(UPBdata$att, 3), labels = c("L", "M", "H"))
impData <- neImpute(UPB ~ attcat * negaff + gender + educ + age,
                    family = binomial, data = UPBdata)
neMod <- neModel(UPB ~ attcat0 * attcat1 + gender + educ + age,
                 family = binomial, expData = impData, se = "robust")
                 
neEffdecomp(neMod)
neEffdecomp(neMod, xRef = c("L", "H"))
neEffdecomp(neMod, xRef = c("M", "H"))


## changing reference levels for continuous exposures
impData <- neImpute(UPB ~ (att + I(att^2)) * negaff + gender + educ + age,
                    family = binomial, data = UPBdata)
neMod <- neModel(UPB ~ (att0 + I(att0^2)) * (att1 + I(att1^2)) + gender + educ + age,
                 family = binomial, expData = impData, se = "robust")
neEffdecomp(neMod)
neEffdecomp(neMod, xRef = c(-1, 0))

## changing covariate levels when allowing for modification 
## of the indirect effect by baseline covariates
impData <- neImpute(UPB ~ (att + negaff + gender + educ + age)^2,
                    family = binomial, data = UPBdata)
neMod <- neModel(UPB ~ att0 * att1 + gender + educ + age + att1:gender + att1:age,
                 family = binomial, expData = impData, se = "robust")
neEffdecomp(neMod)
neEffdecomp(neMod, covLev = c(gender = "F", age = 0)) # default covariate levels
neEffdecomp(neMod, covLev = c(gender = "M", age = 40))
neEffdecomp(neMod, covLev = c(gender = "M", age = 40, educ = "L"))
neEffdecomp(neMod, covLev = c(gender = "M", age = 40, educ = "M"))
neEffdecomp(neMod, covLev = c(gender = "M", age = 40, educ = "H"))
# effect decomposition is independent of education level
neEffdecomp(neMod, covLev = c(gender = "M")) 
# age is set to its default level when left unspecified

}
\seealso{
\code{\link{plot.neLht}}, \code{\link{neLht-methods}}, \code{\link[multcomp]{glht}}, \code{\link[=coef.glht]{glht-methods}}, \code{\link{neModel}}, \code{\link{plot.neModel}}, \code{\link{summary}}
}
