% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{fquantile}
\alias{fquantile}
\title{Predict probabilities and / or outcomes}
\usage{
fquantile(x, probs = seq(0, 1, 0.25), na.rm = FALSE)
}
\arguments{
\item{x}{numeric vector whose sample quantiles are wanted. \code{NA} and \code{NaN}
values are not allowed in numeric vectors unless \code{na.rm} is \code{TRUE}.}

\item{probs}{numeric vector of probabilities with values in \verb{[0,1]}.
(Values up to \code{2e-14} outside that range are accepted and moved to the
nearby endpoint.)}

\item{na.rm}{logical; if \code{TRUE}, any \code{NA} and \code{NaN}'s are removed from \code{x}
before the quantiles are computed.}
}
\value{
A vector of length \code{length(probs)} is returned;
}
\description{
This function is a faster implementation of the "type 7" \code{quantile()}
algorithm and is modified from this gist:
https://gist.github.com/sikli/f1775feb9736073cefee97ec81f6b193
It returns sample quantiles corresponding to the given probabilities.
The smallest observation corresponds to a probability of 0 and the largest
to a probability of 1. For speed, output quantile names are removed as are
error handling such as checking if x are factors, or if probs lie outside
the \verb{[0,1]} range.
}
\examples{
library(logitr)

}
