% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gizmo-density.R
\name{gizmo_density}
\alias{gizmo_density}
\title{Guide gizmo: kernel density estimate}
\usage{
gizmo_density(
  key = waiver(),
  density = NULL,
  density.args = list(),
  density.fun = stats::density,
  just = 0.5,
  oob = "keep",
  alpha = NA,
  theme = NULL,
  position = waiver(),
  direction = NULL
)
}
\arguments{
\item{key}{A \link[=key_sequence]{sequence key} or \link[=key_bins]{binned key}
specification. Internally defaults to a sequence key when the scale is
continuous and a binned key when the scale is binned.}

\item{density}{One of the following:
\itemize{
\item \code{NULL} for using kernel density estimation on the data values (default).
\item a \verb{<numeric>} vector to feed to the \code{density.fun} function.
\item A named \verb{<list>} with \code{x} and \code{y} numeric elements of equal length, such
as one returned by using the \code{\link[stats:density]{density()}} function.
Please note that \verb{<list>} input is expected in scale-transformed space,
not original data space.
}}

\item{density.args}{A \verb{<list>} with additional arguments to the
\code{density.fun} argument. Only applies when \code{density} is not provided as a
\verb{<list>}. already.}

\item{density.fun}{A \verb{<function>} to use for kernel density estimation when
the \code{density} argument is not provided as a list already.}

\item{just}{A \verb{<numeric[1]>} between 0 and 1. Use 0 for bottom- or
left-aligned densities, use 1 for top- or right-aligned densities and 0.5
for violin shapes.}

\item{oob}{An out-of-bounds handling function that affects the cap colour.
Can be one of the following:
\itemize{
\item A \verb{<function>} like \code{\link[scales:oob]{oob_squish}}.
\item A \verb{<character[1]>} naming such a function without the '\code{oob}'-prefix,
such as \code{"keep"}.
}}

\item{alpha}{A \verb{<numeric[1]>} between 0 and 1 setting the colour transparency
of the bar. Use \code{NA} to preserve the alpha encoded in the colour itself.}

\item{theme}{A \code{\link[ggplot2:theme]{<theme>}} object to style the guide individually or
differently from the plot's theme settings. The \code{theme} argument in the
guide overrides and is combined with the plot's theme.}

\item{position}{A \verb{<character[1]>} giving the location of the guide. Can be one of \code{"top"},
\code{"bottom"}, \code{"left"} or \code{"right"}.}

\item{direction}{A \verb{<character[1]>} indicating the direction of the guide. Can be on of
\code{"horizontal"} or \code{"vertical"}.}
}
\value{
A \verb{<GizmoDensity>} object.
}
\description{
This guide displays a kernel density estimate (KDE) of the aesthetic. If the
aesthetic is \code{colour} or \code{fill}, the shape will reflect this.
}
\details{
Non-finite values such as \code{NA} and \code{NaN} are ignored while infinite values
such as \code{-Inf} and \code{Inf} are \link[scales:oob]{squished} to the limits.
}
\examples{
# A standard plot
p <- ggplot(mpg, aes(displ, hwy, colour = cty)) +
  geom_point() +
  scale_colour_viridis_c()

# Density from plot data
p + guides(colour = gizmo_density())

# Using bins instead of gradient
p + guides(colour = gizmo_density("bins"))

# Providing custom values to compute density of
p + guides(colour = gizmo_density(density = runif(1000, min = 5, max = 35)))

# Providing a precomputed density
p + guides(colour = gizmo_density(density = density(mpg$cty, adjust = 0.5)))

# Alternatively, parameters may be passed through density.args
p + guides(colour = gizmo_density(density.args = list(adjust = 0.5)))
}
\seealso{
Other gizmos: 
\code{\link{gizmo_barcap}()},
\code{\link{gizmo_grob}()},
\code{\link{gizmo_histogram}()},
\code{\link{gizmo_stepcap}()}
}
\concept{gizmos}
