% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.ergmm.R
\name{merge.ergmm}
\alias{merge.ergmm}
\title{Merge two or more replications of ERGMM fits}
\usage{
\method{merge}{ergmm}(x, y, ..., verbose = FALSE)
}
\arguments{
\item{x}{The first \code{\link[=ergmm.object]{ergmm}} object to be merged.}

\item{y}{The second \code{\link[=ergmm.object]{ergmm}} object to be merged.}

\item{\dots}{Additional \code{\link[=ergmm.object]{ergmm}} objects to be
merged.}

\item{verbose}{If \code{TRUE}, marks the progress of merging.}
}
\value{
An object of class \code{\link[=ergmm.object]{ergmm}}.
}
\description{
A \code{\link[=merge]{merge}} method for
\code{\link[=ergmm.object]{ergmm}} objects, constructing an
\code{\link[=ergmm.object]{ergmm}} object containing the combined MCMC
output (and derived estimates) of several
\code{\link[=ergmm.object]{ergmm}} objects produced with the same
input parameters but different starting values, random seeds, etc..
}
\examples{

\donttest{
data(sampson)
# Run two short MCMC-based fits.
samp.fit1 <- ergmm(samplike ~ euclidean(d=2, G=3),
  control=ergmm.control(burnin=1000,interval=10,sample.size=2000))
samp.fit2 <- ergmm(samplike ~ euclidean(d=2, G=3),
  control=ergmm.control(burnin=1000,interval=10,sample.size=2000))

# Combine them, and summarize the result.
samp.fit <-  merge(samp.fit1,samp.fit2)
summary(samp.fit)
}

}
\seealso{
\code{\link{ergmm.object}}, \code{\link{ergmm}}
}
\keyword{graphs}
\keyword{models}
