% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.shrink.R
\name{pedigree.shrink}
\alias{pedigree.shrink}
\alias{print.pedigree.shrink}
\title{Shrink pedigree object}
\usage{
pedigree.shrink(ped, avail, affected = NULL, maxBits = 16)

\method{print}{pedigree.shrink}(x, ...)
}
\arguments{
\item{ped}{Pedigree object created by the pedigree function,}

\item{avail}{vector of binary availability status (0/1), i.e. having data, or sample available}

\item{affected}{vector of binary affected status (0/1/NA). If NULL, uses first column of the pedigree object affected matrix.}

\item{maxBits}{Optional, the bit size for which to shrink the pedigree}

\item{x}{pedigree.shrink object used in method functions}

\item{...}{optional arguments passed to internal functions}
}
\description{
Shrink pedigree object to specified bit size with priority placed on trimming
uninformative subjects. The algorithm is useful for getting a pedigree condensed to 
a minimally informative size for algorithms or testing that are limited by size 
of the pedigree.
}
\details{
Iteratively remove subjects from the pedigree. The random removal of members
was previously controlled by a seed argument, but we remove this, forcing users
to control randomness outside the function. First remove uninformative 
subjects, i.e., unavailable (not genotyped) with no available descendants.  
Next, available terminal subjects with unknown phenotype if both parents 
available. Last, iteratively shrinks pedigrees by preferentially removing 
individuals (chosen at random if there are multiple of the same status): 
1. Subjects with unknown affected status, 
2. Subjects with unaffected affected status
3. Affected subjects.
}
\examples{
data(sample.ped)
pedAll <- pedigree(sample.ped$id, sample.ped$father, sample.ped$mother,
  sample.ped$sex, affected=cbind(sample.ped$affected, sample.ped$avail),
  famid=sample.ped$ped)
ped1 <- pedAll['1']
pedigree.shrink(ped1, maxBits=12, avail=ped1$affected[,2])

}
\seealso{
\code{\link{pedigree}}, \code{\link{plot.pedigree.shrink}}
}
\author{
Original by Dan Schaid, updated to kinship2 by Jason Sinnwell
}
