% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legendPlot.R
\name{legendPlot}
\alias{legendPlot}
\title{Legend Pedigree Plot}
\usage{
legendPlot(
  x,
  id = x$id,
  affected = x$affected,
  affected.label = NULL,
  col = 1,
  col.label = NULL,
  symbolsize = 0.75,
  cex = 0.5,
  ...
)
}
\arguments{
\item{x}{Pedigree data frame with ped (pedigree id), id (id of individual),
father (id of father), mother (id of mother), sex, affected (affection status), 
and avail (DNA availability).}

\item{id}{Optional, a character string to replace the correspinding id for persons in the pedigree}

\item{affected}{A variable indicating affection status. A multi-column matrix can be used to
give the status with respect to multiple traits. Logical, factor, and integer types
are converted to 0/1 representing unaffected and affected, respectively. NAs are
considered missing.}

\item{affected.label}{Set labels for affection statuses}

\item{col}{Colors for the plot symbol for each individual}

\item{col.label}{Named vector, with elements matching the unique color codes, the names are the labels used in the legend.}

\item{symbolsize}{Size of symbols (circle/square/triangle). Default is 1.0}

\item{cex}{Character expansion size for labels and ids. Default is 1.0}

\item{...}{Character expansion size for labels and ids. Default is 1.0}
}
\description{
Pedigree plot with ready-made legend along the bottom of the page to represent colors 
and affection statuses
}
\examples{
\dontrun{
data(sample.ped)
pedAll <- pedigree(sample.ped$id, sample.ped$father,
   sample.ped$mother, sample.ped$sex,
   affected=cbind(sample.ped$affected, sample.ped$avail),
   famid=sample.ped$ped)
ped1 <- pedAll["1"]
legendPlot(ped1,  affected.label=c("cancer","available"))
}
}
\seealso{
\code{\link{pedigree}}, \code{\link{plot.pedigree}}
}
\author{
Jason Sinnwell, code contributed by Sara Achenbach
}
