% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_eair_j.R
\name{a_eair100_j}
\alias{a_eair100_j}
\title{Exposure-Adjusted Incidence Rate}
\usage{
a_eair100_j(
  df,
  labelstr = NULL,
  .var,
  .df_row,
  .spl_context,
  .alt_df_full = NULL,
  id = "USUBJID",
  drop_levels = FALSE,
  riskdiff = TRUE,
  ref_path = NULL,
  .stats = c("eair"),
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL,
  na_str = rep("NA", 3),
  conf_level = 0.95,
  fup_var,
  occ_var,
  occ_dy
)
}
\arguments{
\item{df}{(\code{data.frame})\cr data set containing all analysis variables.}

\item{labelstr}{(\code{string})\cr label string for the row.}

\item{.var}{(\code{string})\cr variable name for analysis.}

\item{.df_row}{(\code{data.frame})\cr data frame across all of the columns for the given row split.}

\item{.spl_context}{(\code{data.frame})\cr gives information about ancestor split states.}

\item{.alt_df_full}{(\code{dataframe})\cr denominator dataset for calculations.}

\item{id}{(\code{string})\cr subject variable name.}

\item{drop_levels}{(\code{logical})\cr if TRUE, non-observed levels will not be included.}

\item{riskdiff}{(\code{logical})\cr if TRUE, risk difference calculations will be performed.}

\item{ref_path}{(\code{string})\cr column path specifications for the control group.}

\item{.stats}{(\code{character})\cr statistics to select for the table.}

\item{.formats}{(named 'character' or 'list')\cr formats for the statistics.}

\item{.labels}{(named 'character')\cr labels for the statistics.}

\item{.indent_mods}{(named \code{integer})\cr indent modifiers for the labels.}

\item{na_str}{(\code{string})\cr string used to replace all NA or empty values in the output.}

\item{conf_level}{(\code{proportion})\cr confidence level of the interval.}

\item{fup_var}{(\code{string})\cr variable name for follow-up time.}

\item{occ_var}{(\code{string})\cr variable name for occurrence.}

\item{occ_dy}{(\code{string})\cr variable name for occurrence day.}
}
\value{
\itemize{
\item \code{a_eair100_j} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}
}
\description{
Statistical/Analysis Function for presenting Exposure-Adjusted Incidence Rate summary data
}
\section{Functions}{
\itemize{
\item \code{a_eair100_j()}: Formatted analysis function for exposure adjusted incidence rate summary which is
used as \code{afun} in \code{analyze} or \code{cfun} in \code{summarize_row_groups}.

}}
\examples{
library(tern)
library(dplyr)
trtvar <- "ARM"
ctrl_grp <- "B: Placebo"
cutoffd <- as.Date("2023-09-24")


adexsum <- ex_adsl |>
  create_colspan_var(
    non_active_grp          = ctrl_grp,
    non_active_grp_span_lbl = " ",
    active_grp_span_lbl     = "Active Study Agent",
    colspan_var             = "colspan_trt",
    trt_var                 = trtvar
  ) |>
  mutate(
    rrisk_header = "Risk Difference (95\% CI)",
    rrisk_label = paste(!!rlang::sym(trtvar), "vs", ctrl_grp),
    TRTDURY = case_when(
      !is.na(EOSDY) ~ EOSDY,
      TRUE ~ as.integer(cutoffd - as.Date(TRTSDTM) + 1)
    )
  ) |>
  select(USUBJID, !!rlang::sym(trtvar), colspan_trt, rrisk_header, rrisk_label, TRTDURY)

adexsum$TRTDURY <- as.numeric(adexsum$TRTDURY)

adae <- ex_adae |>
  group_by(USUBJID, AEDECOD) |>
  select(USUBJID, AEDECOD, ASTDY) |>
  mutate(rwnum = row_number()) |>
  mutate(AOCCPFL = case_when(
    rwnum == 1 ~ "Y",
    TRUE ~ NA
  )) |>
  filter(AOCCPFL == "Y")

aefup <- left_join(adae, adexsum, by = "USUBJID")

colspan_trt_map <- create_colspan_map(adexsum,
  non_active_grp = ctrl_grp,
  non_active_grp_span_lbl = " ",
  active_grp_span_lbl = "Active Study Agent",
  colspan_var = "colspan_trt",
  trt_var = trtvar
)

ref_path <- c("colspan_trt", " ", trtvar, ctrl_grp)

################################################################################
# Define layout and build table:
################################################################################

lyt <- basic_table(show_colcounts = TRUE, colcount_format = "N=xx", top_level_section_div = " ") |>
  split_cols_by("colspan_trt", split_fun = trim_levels_to_map(map = colspan_trt_map)) |>
  split_cols_by(trtvar) |>
  split_cols_by("rrisk_header", nested = FALSE) |>
  split_cols_by(trtvar, labels_var = "rrisk_label", split_fun = remove_split_levels(ctrl_grp)) |>
  analyze("TRTDURY",
    nested = FALSE,
    show_labels = "hidden",
    afun = a_patyrs_j
  ) |>
  analyze(
    vars = "AEDECOD",
    nested = FALSE,
    afun = a_eair100_j,
    extra_args = list(
      fup_var = "TRTDURY",
      occ_var = "AOCCPFL",
      occ_dy = "ASTDY",
      ref_path = ref_path,
      drop_levels = TRUE
    )
  )

result <- build_table(lyt, aefup, alt_counts_df = adexsum)
head(result, 5)

}
