% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jpinfect_read_confirmed.R
\name{.col_rename}
\alias{.col_rename}
\title{Clean and Format Column Names}
\usage{
.col_rename(dataset, rep_each = 1)
}
\arguments{
\item{dataset}{A data frame or tibble whose column names need to be cleaned.}

\item{rep_each}{An integer specifying the repetition count for column names. Defaults to \code{1}.}
}
\value{
A character vector containing cleaned and formatted column names.
}
\description{
This helper function cleans and formats column names of a dataset for consistent and readable formatting.
}
\details{
The function removes unnecessary characters, trims whitespace, replaces certain patterns for consistency, and optionally
repeats the column names based on the \code{rep_each} parameter.
}
\keyword{internal}
